//formInnerXDimension = 90;
//formInnerYDimension = 20;
//formInnerZDimension = 30;
//formWallThickness = 2;
//formScrewRadius = 1.8;
//
//customEnclosure(formInnerXDimension, formInnerYDimension, formInnerZDimension, formWallThickness, formScrewRadius, true);
//
//$fn = 100;
//$vpr=[55,0,135];

module customEnclosure(innerXDimension,innerYDimension,innerZDimension,wallThickness, screwRadius, counterSunkTF){
    echo("customEnclosure(innerXDimension,innerYDimension,innerZDimension,wallThickness, screwRadius)");
    difference (){
        shell(innerXDimension,innerYDimension,innerZDimension,wallThickness);
        translate([(innerXDimension)/2+wallThickness,(innerYDimension)/2+wallThickness,(innerZDimension)/2+wallThickness*3]){
            innards(innerXDimension,innerYDimension,innerZDimension,wallThickness);
        }
    }
    screwWingArrangement(wallThickness, screwRadius, innerXDimension,innerYDimension, countersunk = false);
    customLid(innerXDimension,innerYDimension,wallThickness, screwRadius);
}

module customLid(innerXDimension,innerYDimension,wallThickness, screwRadius){
    translate([innerXDimension/2+wallThickness,-(innerYDimension+screwRadius*8),wallThickness/2]){
//        lid(innerXDimension,innerYDimension,wallThickness, screwRadius);
    }
}

module screwWingArrangement(functionThickness, functionHoleRadius, functionXDim, functionYDim){
    screwWingSide = sqrt(pow(7*functionHoleRadius,2)+pow(7*functionHoleRadius,2));
    translate([screwWingSide/2,0,functionThickness/2]){
        rotate([0,0,270]){
            screwWing(functionThickness, functionHoleRadius, countersunk = countersunk);
        }
    }
    translate([functionXDim-screwWingSide/2+functionThickness*2,0,functionThickness/2]){
        rotate([0,0,270]){
            screwWing(functionThickness, functionHoleRadius, countersunk = countersunk);
        }
    }
    translate([screwWingSide/2,functionYDim + functionThickness*2,functionThickness/2]){
        rotate([180,180,270]){
            screwWing(functionThickness, functionHoleRadius, countersunk = countersunk);
        }
    }
    translate([functionXDim-screwWingSide/2+functionThickness*2,functionYDim + functionThickness*2,functionThickness/2]){
        rotate([180,180,270]){
            screwWing(functionThickness, functionHoleRadius, countersunk = countersunk);
        }
    }
}

module screwWing(functionThickness, functionHoleRadius){
    screwWingScale = 7*functionHoleRadius;
    functionInfinity = functionThickness*10;
    rotate([0, 0, 270]){
  	    difference(){
            rotate([0,0,45]){
                cube([screwWingScale, screwWingScale, functionThickness], center = true);
            }
            translate([0, screwWingScale/4, 0]){
                if (countersunk){
                    cylinder(functionThickness+0.01, functionHoleRadius, functionHoleRadius*1.75, center = true);
                }
                cylinder(functionInfinity, functionHoleRadius, functionHoleRadius, center = true);
            }
            translate([0, screwWingScale, 0]){
                cube([screwWingScale, screwWingScale, functionInfinity], center = true);
            }
            translate([0, -screwWingScale/2, 0]){
                cube([2*screwWingScale, screwWingScale, functionInfinity], center = true);
            }
        }
	}
}


module lid(innerXDimension,innerYDimension,wallThickness, holeRadius){
    cube([innerXDimension+wallThickness*2,innerYDimension+wallThickness*2,wallThickness], center = true);
    translate([-innerXDimension/2 - wallThickness, -innerYDimension/2 - wallThickness, -wallThickness/2]){
        screwWingArrangement(wallThickness, holeRadius, innerXDimension,innerYDimension, countersunk = true);
    }
}

module innards(innerXDimension,innerYDimension,innerZDimension,wallThickness){
    cube([innerXDimension, innerYDimension, innerZDimension+wallThickness*4], center = true);
}

module shell(innerXDimension,innerYDimension,innerZDimension,wallThickness){
    translate([innerXDimension/2+wallThickness,innerYDimension/2+wallThickness,innerZDimension/2+wallThickness]){
        cube([innerXDimension+wallThickness*2, innerYDimension+wallThickness*2, innerZDimension+wallThickness*2], center = true);
    }
}